#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 2

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

void setup() {
  Serial.begin(9600);
  sensors.begin();
}

void loop() {
  sensors.requestTemperatures();
  float temperature = sensors.getTempCByIndex(0);
  printTemperature("Temperature", temperature);
  delay(1000);
}

void printTemperature(String label, float value) {
  if (value != DEVICE_DISCONNECTED_C) {
    Serial.println(label + ": " + String(value) + "°C");
  } else {
    Serial.println("Impossibile rilevare la temperatura");
  }
}
