#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 2

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

DeviceAddress airSensorAddress = { 0x28, 0x5E, 0xEB, 0x79, 0xA2, 0x16, 0x03, 0xAF };
DeviceAddress waterSensorAddress = { 0x28, 0xBD, 0x40, 0x79, 0xA2, 0x19, 0x03, 0x84 };

void setup() {
  Serial.begin(9600);
  sensors.begin();
}

void loop() {
  sensors.requestTemperatures();
  float tempAir = sensors.getTempC(airSensorAddress);
  float tempWater = sensors.getTempC(waterSensorAddress);

  Serial.println("Temperature rilevate");
  printTemperature("Aria", tempAir);
  printTemperature("Acqua", tempWater);
  Serial.println();
  delay(1000);
}

void printTemperature(String label, float value) {
  if (value != DEVICE_DISCONNECTED_C) {
    Serial.println(label + ": " + String(value) + "°C");
  } else {
    Serial.println("Impossibile rilevare la temperatura");
  }
}
