#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 2

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

int deviceCount;

void setup() {
  Serial.begin(9600);
  sensors.begin();
  deviceCount = sensors.getDeviceCount();
}

void loop() {
  sensors.requestTemperatures();
  float tempSum = 0;
  for (int i = 0; i < deviceCount; i++) {
    float temperature = sensors.getTempCByIndex(i);
    printTemperature("Sensore " + String(i+1), temperature);
    tempSum += temperature;
  }
  printTemperature("Media", tempSum / deviceCount);
  Serial.println();
  delay(1000);
}

void printTemperature(String label, float value) {
  if (value != DEVICE_DISCONNECTED_C) {
    Serial.println(label + ": " + String(value) + "°C");
  } else {
    Serial.println("Impossibile rilevare la temperatura");
  }
}
