#include <LiquidCrystal_I2C.h>
#define ANALOG_PIN A0
#define ENABLE_PIN 3
#define MIN_VALUE 280
#define MAX_VALUE 1000

LiquidCrystal_I2C lcd(0x27, 16, 2);

void setup() {
  lcd.init();
  lcd.backlight();
  pinMode(ENABLE_PIN, OUTPUT);
}

void loop() {
  digitalWrite(ENABLE_PIN, HIGH);
  delay(200);
  int value = analogRead(ANALOG_PIN);
  digitalWrite(ENABLE_PIN, LOW);

  int h = map(value, MIN_VALUE, MAX_VALUE, 100, 0);
  h = constrain(h, 0, 100);

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Umidita' del");
  lcd.setCursor(0, 1);
  lcd.print("terreno: " + String(h) + "%");
  
  delay(1000);
}
