#include <AccelStepper.h>
#define STEPS_PER_REVOLUTION 2048
#define IN1 8
#define IN2 9
#define IN3 10
#define IN4 11

AccelStepper stepper(AccelStepper::FULL4WIRE, IN1, IN3, IN2, IN4);
int direction = 1;

void setup() {
  stepper.setMaxSpeed(512);
  stepper.setAcceleration(100);
  stepper.move(direction * STEPS_PER_REVOLUTION);
}

void loop() {
  if (stepper.distanceToGo() == 0) {
    direction *= -1;
    stepper.move(direction * STEPS_PER_REVOLUTION);
  }

  stepper.run();
}

