#include <AccelStepper.h>
#define IN1 8
#define IN2 9
#define IN3 10
#define IN4 11
#define BUTTON_PIN 2
#define POT_PIN A0

AccelStepper stepper(AccelStepper::HALF4WIRE, IN1, IN3, IN2, IN4);
unsigned long debounceTime = 0;
int lastButtonState = LOW;
int direction = 1;

void setup() {
  stepper.setMaxSpeed(1024);
  pinMode(BUTTON_PIN, INPUT);
}

void loop() {
  int speed = analogRead(POT_PIN);
  int buttonState = digitalRead(BUTTON_PIN);
  int currentTime = millis();

  if (buttonState == HIGH && lastButtonState == LOW) {
    if (currentTime - debounceTime > 200) {
      direction *= -1;
      debounceTime = currentTime;
    }
  }
  lastButtonState = buttonState;

  stepper.setSpeed(direction * speed);
  stepper.runSpeed();
}

